<?php

namespace App\Services;

use App\Models\Education;
use App\Models\Lesson;
use Illuminate\Support\Facades\Session;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\User;

class CartService
{

    public function getCart()
    {
        return Session::get('cart', []);
    }

    public function addToCart(string $type, int $id)
    {
        $cart = $this->getCart();

        if ($type === 'education') {
            $edu = Education::findOrFail($id);

            if (!isset($cart['education'])) {
                $cart['education'] = [];
            }

            $cart['education'][$id] = [
                'id'  => $edu->id,
                'title' => $edu->title,
                'price' => $edu->amount,
            ];

            if (isset($cart['lessons'][$id])) {
                unset($cart['lessons'][$id]);
            }
        } elseif ($type === 'lesson') {
            $lesson = Lesson::findOrFail($id);
            $edu_id = $lesson->edu_id;

            if (isset($cart['education'][$edu_id])) {
                return ['success' => false, 'message' => 'کل دوره در سبد خرید شما موجود میباشد'];
            }

            if (!isset($cart['lessons'][$edu_id])) {
                $cart['lessons'][$edu_id] = [];
            }

            $cart['lessons'][$edu_id][$lesson->id] = [
                'id'    => $lesson->id,
                'title' => $lesson->title,
                'price' => $lesson->amount,
            ];

            $totalLessonsPrice = collect($cart['lessons'][$edu_id])->sum('price');
            $edu = Education::find($edu_id);

            if ($edu && $totalLessonsPrice >= $edu->amount) {

                $cart['education'][$edu_id] = [
                    'id'    => $edu->id,
                    'title' => $edu->title,
                    'price' => $edu->amount,
                ];
                unset($cart['lessons'][$edu_id]);
            }
        }

        Session::put('cart', $cart);
        return ['success' => true, 'message' => 'به سبد خرید افزوده شد'];
    }

    public function removeFromCart(string $type, int $id)
    {
        $cart = $this->getCart();

        if ($type == 'education') {
            unset($cart['education'][$id]);
        } elseif ($type == 'lesson') {
            foreach ($cart['lessons'] ?? [] as $edu_id => $lesson) {
                unset($cart['lessons'][$edu_id][$id]);
                if (empty($cart['lessons'][$edu_id])) {
                    unset($cart['lessons'][$edu_id]);
                }
            }
        }

        Session::put('cart', $cart);
        return ['success' => true, 'message' => 'سبد خرید ویرایش شد'];
    }

    public function clearCart()
    {
        return Session::forget('cart');
    }

    public function getCartTotal(): float
    {
        $cart = $this->getCart();
        $total = 0;

        if (isset($cart['education'])) {
            foreach ($cart['education'] as $edu) {
                $total += $edu['price'];
            }
        }


        if (isset($cart['lessons'])) {
            foreach ($cart['lessons'] as $eduLessons) {
                foreach ($eduLessons as $lesson) {
                    $total += $lesson['price'];
                }
            }
        }

        return $total;
    }

    public function checkout(){
        $cart = session('cart', []);
    
        $total = 0;
    
        $order = Order::create([
            'user_id' => auth()->id(),
            'amount' => 0, 
            'status' => 'pending',
        ]);
    
   
        foreach($cart['education'] ?? [] as $edu) {
            $total += $edu['price'];
            $order->items()->create([
                'item_type' => 'education',
                'item_id' => $edu['id'],
                'title' => $edu['title'],
                'amount' => $edu['price'],
            ]);

            $education = Education::findOrFail($edu['id']);
            if ($education->commission != 0) {
                $commission = $edu['price'] * $education->commission / 100;
                $education->teacher->deposit($commission , "کمیسیون خرید دوره");
            }

            auth()->user()->educations()->attach((int) $edu['id']);
        }
    
     
        foreach($cart['lessons'] ?? [] as $eduLessons) {
            foreach($eduLessons as $lesson) {
                $total += $lesson['price'];
                $order->items()->create([
                    'item_type' => 'lesson',
                    'item_id' => $lesson['id'],
                    'title' => $lesson['title'],
                    'amount' => $lesson['price'],
                ]);

                $lesson = Lesson::findOrFail($lesson['id']);
                if ($lesson->commission != 0) {
                    $commission = $lesson['price'] * $education->commission / 100;
                    $lesson->education->teacher->deposit($commission , "کمیسیون خرید جلسه");
                }

                auth()->user()->lessons()->attach((int) $lesson['id']);
            }
        }
    
        $order->update(['amount' => $total]);

        $this->clearCart();
    }
}
