<?php

// app/Notifications/SendResetCode.php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class SendResetCode extends Notification
{
    use Queueable;

    protected string $code;

    public function __construct(string $code)
    {
        $this->code = $code;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('کد بازیابی رمز عبور')
                    ->line("کد بازیابی رمز شما: {$this->code}")
                    ->line('این کد تا ۱۰ دقیقه معتبر است.');
    }
}
