<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WithdrawRequest extends Model
{
    use HasFactory;

    public static function booted()
    {
        static::creating(function ($req) {
            do {
                $rand = str_pad(random_int(0, 99999999), 8, '0', STR_PAD_LEFT);
            } while (WithdrawRequest::where('request_number', $rand)->exists());

            $req->request_number = $rand;
        });
    }

    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function getStatus()
    {
        switch ($this->status) {
            case 'pending':
                return ['msg' => 'درحال بررسی', 'color' => 'text-info'];
                break;
            case 'reject':
                return ['msg' => 'رد شده', 'color' => 'text-danger'];
                break;
            case 'accept':
                return ['msg' => 'تایید شده', 'color' => 'text-success'];
                break;
        }
    }
}
