<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Wallet extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function walletable(){
        return $this->morphTo();
    }

    public function transactions(){
        return $this->hasMany(WalletTransaction::class , 'wallet_id');
    }

    public function deposit($amount , $des = null){
        $this->increment('balance' , $amount);
        $this->transactions()->create([
            'type' => 'deposit',
            'amount' => $amount,
            'description' => $des,
        ]);
    }

    public function withdraw($amount , $des = null){
        if ($this->balance < $amount) {
            throw new \Exception('insufficient balance');
        }
        $this->decrement('balance' , $amount);

        $this->transactions()->create([
            'type' => 'deposit',
            'amount' => $amount,
            'description' => $des,
        ]);
    }
}
