<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class ProductEncyclopedia extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function chemistry()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','chemistry');
    }
    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo');
    }
    public function gallery()
    {
        return $this->morphMany('App\Models\Photo', 'pictures')->where('status','active')->where('type','gallery');
    }
    public function gallery_mobile()
    {
        return $this->morphMany('App\Models\Photo', 'pictures')->where('status','active')->where('type','gallery_mobile');
    }
    public function attrs()
    {
        return $this->hasMany('App\Models\ProductEncyclopediaAttr', 'item_id');
    }
    public function attrs_active()
    {
        return $this->hasMany('App\Models\ProductEncyclopediaAttr', 'item_id')->CheckStatus()->orderBy('sort');
    }
    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang',app()->getLocale())->where('col_name','status')->where('text','active');
    }
    public function scopeCheckStatus($query)
    {
        // بررسی زبان پیش‌فرض و فیلتر بر اساس آن
        if (default_lang() == lang()) {
            return $query->where('status', 'active'); // برای زبان پیش‌فرض
        } else {
            return $query->whereHas('lang_active');  // برای زبان دوم
        }
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if($item->photo)
            {
                if(is_file($item->photo->path))
                {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }
            if(count($item->gallery))
            {
                foreach ($item->gallery as $photo)
                {
                    if(is_file($photo->path))
                    {
                        File::delete($photo->path);
                        delete_directory($photo->path);
                    }
                    $photo->delete();
                }
            }
            if(count($item->gallery_mobile))
            {
                foreach ($item->gallery_mobile as $photo)
                {
                    if(is_file($photo->path))
                    {
                        File::delete($photo->path);
                        delete_directory($photo->path);
                    }
                    $photo->delete();
                }
            }

            if(count($item->langs))
            {
                foreach ($item->langs as $lang)
                {
                    $lang->delete();
                }
            }
            if(count($item->attrs))
            {
                foreach ($item->attrs as $attr)
                {
                    $attr->delete();
                }
            }

        });
    }
}
