<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class ProductCategory extends Model
{
    protected $fillable = ['parent_id','title','status','slug'];
    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photo');
    }

    public function parent()
    {
        return $this->belongsTo(ProductCategory::class, 'parent_id');
    }

    public function childs()
    {
        return $this->hasMany(ProductCategory::class, 'parent_id')->orderBy('sort');
    }
    public function products()
    {
        return $this->hasMany(Product::class, 'category_id');
    }
    public function products_active()
    {
        return $this->hasMany(Product::class, 'category_id')->checkStatus();
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lang_active()
    {
        return $this->morphOne('App\Models\Lang', 'langs')->where('lang', app()->getLocale())->where('col_name', 'status')->where('text', 'active');
    }
    public function scopeCheckStatus($query)
    {
        // بررسی زبان پیش‌فرض و فیلتر بر اساس آن
        if (default_lang() == lang()) {
            return $query->where('status', 'active'); // برای زبان پیش‌فرض
        } else {
            return $query->whereHas('lang_active');  // برای زبان دوم
        }
    }
    public function childs_active()
    {
        return $this->hasMany(ProductCategory::class, 'parent_id')->checkStatus()->orderBy('sort');
    }
    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if ($item->photo) {
                if (is_file($item->photo->path)) {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }

            if (count($item->langs)) {
                foreach ($item->langs as $lang) {
                    $lang->delete();
                }
            }

        });
    }
}
