<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Photo extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function pictures()
    {
        return $this->morphTo();
    }

    public function blog()
    {
        return $this->belongsTo('\App\Models\Blog', 'pictures_id');
    }

    public function product()
    {
        return $this->belongsTo('\App\Models\Product', 'pictures_id');
    }

}
