<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;
    protected $guarded = [];

    public static function booted()
    {
        static::creating(function ($order) {
            do {
                $rand = str_pad(random_int(0, 99999999), 8, '0', STR_PAD_LEFT);
            } while (Order::where('order_number', $rand)->exists());

            $order->order_number = $rand;
        });
    }

    public function items(){
        return $this->hasMany(OrderItem::class);
    }

    public function user(){
        return $belongsTo(User::class);
    }
}
