<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LibraryCat extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photo');
    }

    public function childs(){
        return $this->hasMany(LibraryCat::class , 'parent_id');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }
}
