<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Library extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function photo(){
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photo');
    }

    public function attachment(){
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'attachment');
    }

    public function category(){
        return $this->belongsTo(LibraryCat::class , 'cat_id');
    }

    public function langs(){
        return $this->morphMany('App\Models\Lang', 'langs');
    }
}
