<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lesson extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function photo(){
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photo');
    }

    public function attachment(){
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'attachment');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function education(){
        return $this->belongsTo(Education::class ,'edu_id');
    }

    public function chapter(){
        return $this->belongsTo(Chapter::class ,'chapter_id');
    }
}
