<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Gallery extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function category()
    {
        return $this->belongsTo('App\Models\GalleryCategory', 'category_id');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {
            if(is_file($item->file))
            {
                File::delete($item->file);
                delete_directory($item->file);
            }

        });
    }
}
