<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EducationCat extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function photo(){
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photo');
    }

    public function childs(){
        return $this->hasMany(EducationCat::class , 'parent_id');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function educations(){
        return $this->hasMany(Education::class , 'cat_id');
    }

    public function educationsCount(){
        $count = 0;

        $count += $this->educations->count();

        if ($this->childs) {
            foreach ($this->childs as $key => $child) {
                $count += $child->educations->count();
            }
        }

        return $count;
    }
}
