<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use PDO;

class Education extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function getType(){
        if ($this->type == 'offline') {
            return 'آفلاین';
        }
        return 'آنلاین';
    }


    public function groups(){
        return $this->hasMany(EducationGroup::class , 'education_id');
    }

    public function users(){
        return $this->belongsToMany(User::class , 'education_user');
    }

    public function photo(){
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'photo');
    }

    public function attachment(){
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status', 'active')->where('type', 'attachment');
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function category(){
        return $this->belongsTo(EducationCat::class , 'cat_id');
    }

    public function teacher(){
        return $this->belongsTo(User::class , 'teacher_id');
    }

    public function chapters(){
        return $this->hasMany(Chapter::class , 'education_id');
    }

    public function lessons(){
        return $this->hasMany(Lesson::class , 'edu_id');
    }

    public function lessonsCount(){
        return $this->lessons->count();
    }

    public function nonGroupUsers(){
        $allUsers = $this->users()->pluck('users.id');
        $gps = EducationGroup::where('education_id' , $this->id)->with('users:id')->get()->pluck('users.*.id')->flatten()->unique();
        $nonGp = User::whereIn('id' , $allUsers)->whereNotIn('id' , $gps)->get();
        return $nonGp;
    }

}
