<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\File;

class Contact extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'pictures')->where('status','active')->where('type','photo');
    }

    public static function expload_function($item)
    {
        $items=explode(',',$item);
        return $items;
    }

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    protected static function boot()
    {
        parent::boot();
        static::deleting(function ($item) {

            if($item->photo)
            {
                if(is_file($item->photo->path))
                {
                    File::delete($item->photo->path);
                    delete_directory($item->photo->path);
                }
                $item->photo->delete();
            }

            if(count($item->langs))
            {
                foreach ($item->langs as $lang)
                {
                    $lang->delete();
                }
            }

        });
    }
}