<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    protected $fillable = ['name', 'email', 'message', 'parent_id'];

    // رابطه پلیمورفیک
    public function commentable()
    {
        return $this->morphTo();
    }

    // رابطه برای پاسخ‌ها
    public function replies()
    {
        return $this->hasMany(Comment::class, 'parent_id');
    }

    // رابطه برای کامنت والد
    public function parent()
    {
        return $this->belongsTo(Comment::class, 'parent_id');
    }

    // public function scopeCheckStatus($query)
    // {
    //     return $query->where('status', 'active'); 
    // }
}
