<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chapter extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function langs()
    {
        return $this->morphMany('App\Models\Lang', 'langs');
    }

    public function lessons(){
        return $this->hasMany(Lesson::class , 'chapter_id');
    }

    public function education(){
        return $this->belongsTo(Education::class , 'education_id');
    }
}
