<?php

namespace App\Http\Requests\Setting;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class RedirectRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                $type=$this->request->get('type');
                if($type == 410 || $type == 404)
                {
                    return [
                        'title' => 'required|max:250',
                        'from' => 'required|url|unique:redirects',
                    ];
                }
                else
                {
                    return [
                        'title' => 'required|max:250',
                        'from' => 'required|url|unique:redirects',
                        'to' => 'required|url',
                    ];
                }
            }
            case 'PATCH':
            {
                $type=$this->request->get('type');
                $id=$this->request->get('id');
                if($type == 410 || $type == 404)
                {
                    return [
                        'title' => 'required|max:250',
                        'from' => 'required|url|unique:redirects,from,'.$id,
                    ];
                }
                else
                {
                    return [
                        'title' => 'required|max:250',
                        'from' => 'required|url|unique:redirects,from,'.$id,
                        'to' => 'required|url',
                    ];
                }
            }
            default:
                break;
        }
    }
}
