<?php

namespace App\Http\Requests\Setting;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class LangSetRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|max:150',
                    'lang' => 'required|unique:lang_sets',
                    'faker' => 'required|unique:lang_sets',
                    'align' => 'required',
                    'status' => 'required',
                    'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:1024",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'title' => 'required|max:150',
                    'lang' => 'required|unique:lang_sets,lang,'.$id,
                    'faker' => 'required|unique:lang_sets,faker,'.$id,
                    'align' => 'required',
                    'status' => 'required',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:1024",
                ];
            }
            default:
                break;
        }
    }
}
