<?php

namespace App\Http\Requests\Product;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class ProductEncyclopediaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'title' => 'required|max:175',
                    'slug' => 'required|max:220|unique:product_encyclopedias,slug',
                    'text1' => 'required',
                    'chemistry' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                    'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                ];
            }
            case 'PATCH':
            {
                $id=$this->request->get('id');
                return [
                    'title' => 'required|max:175',
                    'slug' => 'required|max:220|unique:product_encyclopedias,slug,' . $id,
                    'text1' => 'required',
                    'chemistry' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                ];
            }
            default:
                break;
        }
    }
}
