<?php

namespace App\Http\Requests\Other;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class TeamRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        switch ($this->method()) {
            case 'GET':
            case 'DELETE':
            {
                return [];
            }
            case 'POST':
            {
                return [
                    'name' => 'required|max:100',
                    'text' => 'required|max:500',
                    'dis' => 'required|max:2000',
                    'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                ];
            }
            case 'PATCH':
            {
                return [
                    'name' => 'required|max:100',
                    'text' => 'required|max:500',
                    'dis' => 'required|max:2000',
                    'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                ];
            }
            default:
                break;
        }
    }
}
