<?php

namespace App\Http\Requests\Library;

use Illuminate\Foundation\Http\FormRequest;

class LibraryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        if ($this->method() == 'post') {
            return [
                'status' => 'required',
                'slug' => 'required',
                'title' => 'required',
                'text' => 'required',
                'category_id' => 'required',
                'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                'attachment' => 'required|mimes:pdf|max:6000'
            ];
        } else {
            return [
                'status' => 'required',
                'slug' => 'required',
                'title' => 'required',
                'text' => 'required',
                'category_id' => 'required',
                'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                'attachment' => 'nullable|mimes:pdf|max:6000'
            ];
        }
    }
}
