<?php

namespace App\Http\Requests\Education;

use Illuminate\Foundation\Http\FormRequest;

class EducationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        if ($this->method() == 'post') {
            return [
                'status' => 'required',
                'type' => 'required',
                'commission' => 'required',
                'title' => 'required',
                'text' => 'required',
                'catgory_id' => 'requried',
                'amount' => 'required',
                'slug' => 'required',
                'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                'attachment' => 'nullable|mimes:pdf|max:6000',
                'start_rege_date' => 'required',
                'end_rege_date' => 'required',
                'start_date' => 'required',
                'end_date' => 'required',
            ];
        }else{
            return [
                'status' => 'required',
                'type' => 'required',
                'title' => 'required',
                'commission' => 'required',
                'text' => 'required',
                'catgory_id' => 'requried',
                'amount' => 'required',
                'slug' => 'required',
                'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                'attachment' => 'nullable|mimes:pdf|max:6000',
                'start_rege_date' => 'required',
                'end_rege_date' => 'required',
                'start_date' => 'required',
                'end_date' => 'required',
            ];
        }
    }
}
