<?php

namespace App\Http\Requests\Education;

use Illuminate\Foundation\Http\FormRequest;

class EducationLessonsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        if ($this->method() == 'post') {
            return [
                'status' => 'required',
                'edu_id' => 'required',
                'chapter_id' => 'required',
                'commission' => 'required',
                'title' => 'required',
                'amount' => 'required',
                'text' => 'required',
                'slug' => 'required',
                'photo' => "required|image|mimes:jpeg,jpg,png,webp|max:512",
                'attachment' => 'nullable|mimes:pdf|max:6000',
                'link' => 'required'
            ];
        }else{
            return [
                'status' => 'required',
                'edu_id' => 'required',
                'chapter_id' => 'required',
                'commission' => 'required',
                'title' => 'required',
                'amount' => 'required',
                'text' => 'required',
                'slug' => 'required',
                'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
                'attachment' => 'nullable|mimes:pdf|max:6000',
                'link' => 'required'
            ];
        }
    }
}
