<?php

namespace App\Http\Requests\Education;

use Illuminate\Foundation\Http\FormRequest;

class EducationCatRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        if ($this->method() == 'post') {
            return [
                'parent_id' => 'required',
                'title' => 'required|max:255',
                'slug' => 'required|max:255|unique:product_categories,slug',
                'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
            ];
        } else {
            $id = $this->request->get('id');
            return [
                'parent_id' => 'required',
                'title' => 'required|max:255',
                'slug' => 'required|max:255|unique:product_categories,slug,' . $id,
                'photo' => "nullable|image|mimes:jpeg,jpg,png,webp|max:512",
            ];
        }
    }
}
