<?php

namespace App\Http\Middleware\Financial;

use App\Models\WithdrawRequest;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class WithdrawRequestMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $req = WithdrawRequest::findOrFail($request->route()->parameters()['id']);
        if ($req->status != 'pending') {
            return redirect()->back()->withInput()->with('err_message', 'دراین وضعیت امکان تغییر وجود ندارد');
        }

        return $next($request);
    }
}
