<?php



namespace App\Http\Controllers\Front;



use App\Models\Slider;

use App\Models\ProductEncyclopedia;

use App\Models\About;

use App\Models\Product;

use App\Models\Education;

use App\Models\Partner;

use App\Models\Banner;

use App\Models\User;

use App\Models\Certificate;

use App\Models\Contact;

use App\Models\CountryCode;

use App\Models\ContactForm;

use App\Models\Blog;

use App\Models\Service;

use App\Models\Faq;

use App\Models\Setting;

use App\Models\GalleryCategory;

use App\Models\ProductCategory;

use App\Models\Tag;

use App\Models\Team;

use App\Mail\Mail;



use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use Carbon\Carbon;



class HomeController extends Controller

{



    public function index()

    {

        $details = [

                'subject' => 'test',

                'title' => 'test',

                'body' => 'test'

            ];

        \Mail::to('aabdolmaleki25@gmail.com')->send(new Mail($details));

        // dd('ok');

        //slider

        $sliders = Slider::whereHas('photo')->whereIN('type',['image','video'])->checkStatus()->orderBy('sort')->get();

        //ProductEncyclopedia

        $product_encyclopedias = ProductEncyclopedia::where('status_home', 'active')->checkStatus()->orderBy('sort')->take(6)->get();

        //about

        $about = About::where('type', 'home')->first();

        //product

        $products = Product::checkStatus()->orderByDesc('id')->take(12)->get();

        //about contact

        $about_contact = About::where('type', 'home_map')->first();

        //faq

        $faqs = Faq::where('status_home', 'active')->checkStatus()->orderBy('sort')->take(10)->get();

        //blogs

        $blogs = Blog::checkStatus()->orderByDesc('id')->take(10)->get();

        $educations = Education::latest()->take(4)->get();
        $partners = Partner::checkStatus()->orderByDesc('id')->take(15)->get();

        return view('front.index', compact( 'educations' ,'sliders','product_encyclopedias', 'about','products', 'about_contact', 'faqs', 'blogs','partners'), ['title' => read_lang_word('title-home')]);

    }



    public function about($slug=null)

    {

        if (blank($slug))

        {

            $slug='about';

            $title=read_lang_word('title-about');

        }



        $item = About::where('type', str_replace('-','_',$slug))->first();

        if ($slug != 'about')

        {

            $title=read_lang($item,'title');

        }



        $partners = Partner::get();

        return view('front.about', compact('item', 'partners'), ['title' =>  $title]);

    }



    public function certificate()

    {

        $items = Certificate::checkStatus()->get();

        return view('front.certificate', compact('items'), ['title' =>  read_lang_word('certificates')]);

    }

    public function faq()

    {

        $items = Faq::checkStatus()->orderBy('sort')->get();

        return view('front.faq', compact('items'), ['title' =>  read_lang_word('title-faq')]);

    }



    public function contact()

    {

        $items = Contact::get();

        // dd($item);

        return view('front.contact', compact('items'), ['title' =>  read_lang_word('title-contact')]);

    }



     public function contact_post(Request $request)

    {

        $this->validate($request, [

            'name' => 'required|max:200',

            'email' => 'required|email|max:200',

            'message' => 'required',

        ]);



        try {

            $item = ContactForm::create([

                'name' => $request->name,

                'email' => $request->email,

                'message' => $request->message,

            ]);



            // $text='<div dir="rtl">';

            //     $text.='<p>';

            //         $text.= 'نام : '.$item->name;

            //     $text.='</p>';



            //     $text.='<p>';

            //         $text.= 'تلفن : '.$item->phone;

            //     $text.='</p>';



            //     $text.='<p>';

            //         $text.= 'پیام : '.$item->message;

            //     $text.='</p>';

            // $text.='</div>';

        

            // $details = [

            //     'subject' => $request->subject,

            //     'title' => $request->subject,

            //     'body' => $text

            // ];



            // $contact = Contact::first();

            // $emails = explode(',' , $contact->email_form);

     

            // foreach ($emails  as $email ) {

            //     \Mail::to($email)->send(new Mail($details));

            // }



            return redirect()->back()->with('flash_message',read_lang_word('msg-success-form'));

        } catch (\Exception $e) {

            return redirect()->back()->with('err_message',read_lang_word('msg-err-form'));

        }

    }



    public function comment_post(Request $request)

    {

        $request->validate([

            'name' => 'required|string|max:255',

            'email' => 'required|email|max:255',

            'message' => 'required|string',

            'commentable_id' => 'required|integer',

            'commentable_type' => 'required|string'

        ]);



        try {

            $model = $request->commentable_type::findOrFail($request->commentable_id);



            $model->comments()->create([

                'name' => $request->name,

                'email' => $request->email,

                'message' => $request->message

            ]);



            return redirect()->back()->with('flash_message',read_lang_word('msg-success-form'));

        } catch (\Exception $e) {

            return redirect()->back()->with('err_message',read_lang_word('msg-err-form'));

        }

    }



    public function service_list()

    {

        $items = Service::checkStatus()->orderBy('sort')->paginate(24);

        return view('front.service.index', compact('items'), ['title' => read_lang_word('title-service')]);

    }



    public function blog_list()

    {

        $items = Blog::checkStatus()->orderBy('sort')->paginate(12);

        return view('front.blog.index', compact('items'), ['title' => read_lang_word('title-blog')]);

    }



    public function blog_show($slug)

    {

        

        $item = Blog::where('slug', $slug)->checkStatus()->firstOrFail();

        $item->seen += 1;

        $item->update();

        //tag

      

        if(!empty($item->tags)){

            $tags=Tag::whereIN('id',$item->tags)->checkStatus()->get();

        }else{

            $tags=null;

        }

       

        //last items

        $items_last = Blog::orderByDesc('id')->where('id', '!=', $item->id)->checkStatus()->take(5)->get();

        //seen

        $items_seen = Blog::orderByDesc('seen')->where('id', '!=', $item->id)->checkStatus()->take(5)->get();



        $comments = $item->comments->where('parent_id',null)->where('status', true);

   

        return view('front.blog.show', compact('item', 'items_last', 'items_seen','tags', 'comments'), ['title' => read_lang($item, 'title')]);

    }

    public function tag_show($slug)

    {

        $item = Tag::where('slug', $slug)->checkStatus()->firstOrFail();

        //last items

        $blogs = Blog::orderByDesc('id')->where('tags', 'LIKE', '%"'.$item->id.'"%')->checkStatus()->paginate('24');

        return view('front.tag.show', compact('item', 'blogs'), ['title' => read_lang($item, 'title')]);

    }



    public function product_list($slug = null)

    {

        $title=read_lang_word('products');

        $products=Product::checkStatus()->orderByDesc('id')->paginate(24);

        $item=null;

        if(!blank($slug))

        {

            $item=ProductCategory::where('slug',$slug)->checkStatus()->firstOrFail();

            $title=read_lang($item,'title');



            $products=Product::where('category_id',$item->id)->checkStatus()->orderByDesc('id')->paginate(24);

        }

        $breadcrumb=[];

        array_push($breadcrumb,['title'=>read_lang_word('products') , 'url'=>route('front.product.list')]);

        if($item)

        {

            if($item->parent)

            {

                array_push($breadcrumb,['title'=>read_lang($item->parent,'title') , 'url'=>route('front.product.list',$item->parent->slug)]);

            }

            array_push($breadcrumb,['title'=>read_lang($item,'title') , 'url'=>route('front.product.list',$item->slug)]);

        }



        return view('front.product.index', compact('products','item'), ['title' => $title,'breadcrumb'=>$breadcrumb]);

    }

    public function product_show($slug)

    {

        $item=Product::checkStatus()->where('slug',$slug)->firstOrFail();

        $cat=ProductCategory::findOrFail($item->category_id);



        $products=Product::where('id','!=',$item->id)->where('category_id',$item->category_id)->checkStatus()->orderByDesc('id')->take(18)->get();

        $breadcrumb=[];

        array_push($breadcrumb,['title'=>read_lang_word('products') , 'url'=>route('front.product.list')]);

        if($cat)

        {

            array_push($breadcrumb,['title'=>read_lang($cat,'title') , 'url'=>route('front.product.list',$cat->slug)]);

        }

        array_push($breadcrumb,['title'=>read_lang($item,'title') , 'url'=>route('front.product.show',$item->slug)]);



        return view('front.product.show', compact('item','products'), ['title' => read_lang($item,'title'),'breadcrumb'=>$breadcrumb]);

    }

    public function encyclopedia_list()

    {

        $items=ProductEncyclopedia::checkStatus()->orderBy('sort')->take(6)->get();



        return view('front.encyclopedia.index', compact('items'), ['title' => read_lang_word('encyclopedia')]);

    }

    public function encyclopedia_show($slug)

    {

        $item=ProductEncyclopedia::checkStatus()->where('slug',$slug)->firstOrFail();

        $products=Product::whereIN('id',json_decode($item->product_id))->checkStatus()->get();

        $similar_items=ProductEncyclopedia::checkStatus()->take(10)->get();

        $breadcrumb=[];

        array_push($breadcrumb,['title'=>read_lang_word('encyclopedia') , 'url'=>route('front.encyclopedia.list')]);

        if($item)

        {

            array_push($breadcrumb,['title'=>read_lang($item,'title') , 'url'=>route('front.encyclopedia.list',$item->slug)]);

        }

        return view('front.encyclopedia.show', compact('item','products','similar_items'), ['title' => read_lang($item,'title'),'breadcrumb'=>$breadcrumb]);

    }



    public function gallery()

    {

        $items = GalleryCategory::checkStatus()->orderBy('sort')->paginate(24);

        return view('front.gallery.index', compact('items'), ['title' => read_lang_word('title-gallery')]);

    }



    public function rules(){

         $item = About::where('type', 'rules')->firstOrFail();

         return view('front.rules', compact('item'), ['title' => read_lang_word('title-gallery')]);



    }



}

