<?php

namespace App\Http\Controllers\Front\Financial;

use App\Http\Controllers\Controller;
use App\Http\Requests\Financial\withdrawReqeust;
use App\Services\FinancialService;
use App\Services\TransactionService;
use Illuminate\Http\Request;

class WithdrawRequestController extends Controller
{
    protected $f_service;
    public function __construct(FinancialService $f_service)
    {
        $this->f_service = $f_service;
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $withdrawRequests = auth()->user()->withdrawRequests;
        return view('front.withdraw_request.index' , compact('withdrawRequests'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('front.withdraw_request.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(withdrawReqeust $request)
    {

        $transctions = TransactionService::run(function() use ($request){
           $this->f_service->withdraw_request($request);
        });
        if (!$transctions['result']) {
            return redirect()->back()->with('err_message', $transctions['message']);
        }
        return redirect()->back()->with('flash_message', 'درخواست شما ثبت شد');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
