<?php

namespace App\Http\Controllers\Front\Financial;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\OrderItem;
use App\Services\CartService;
use App\Services\TransactionService;

class CheckoutController extends Controller
{
    protected $c_service;
    public function __construct(CartService $c_service)
    {
        $this->c_service = $c_service;   
    }

    public function checkout(Request $request){
        $cart = session('cart', []);
        if(empty($cart)) {
            return redirect()->back()->with('error', 'سبد خرید خالی است');
        }

        $transaction = TransactionService::run(function(){
            $this->c_service->checkout();
        });

        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'خطا در صورتحساب');
        }
        return redirect()->back()->with('flash_message', 'خرید شما انجام شد');
    }
}
