<?php

namespace App\Http\Controllers\Front\Education;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EducationCat;
use App\Models\Education;
use App\Models\Lesson;

class EducationsController extends Controller
{
    public function categories(){
        $cats = EducationCat::all();
        return view('front.education.categories' , compact('cats'));
    }

    public function educations(){
        $educations = Education::latest()->paginate(10);
        $cats = EducationCat::all();
        return view('front.education.educations' , compact('educations' , 'cats'));
    }

    public function education($id){
        $edu = Education::findOrFail($id);
        return view('front.education.single-education' , compact('edu'));
    }

    public function lesson($id){
        $lesson = Lesson::findOrFail($id);
        $edu = $lesson->education;

        return view('front.education.single-lesson' , compact('lesson' , 'edu'));
    }
}
