<?php

namespace App\Http\Controllers\Front\Cart;

use App\Http\Controllers\Controller;
use App\Services\CartService;
use Illuminate\Http\Request;

class CartController extends Controller
{
    private $c_service;
    public function __construct(CartService $c_service)
    {
        return $this->c_service = $c_service;
    }

    public function addToCart($id , $type){
       $addToCart =  $this->c_service->addToCart($type ,(int) $id);
        if (!$addToCart['success']) {
            return redirect()->back()->with('err_message', $addToCart['message']);
        }
        return redirect()->back()->with('flash_message', $addToCart['message']);
    }

    public function RemoveFromCart($id , $type){
        $removeFromCart =  $this->c_service->removeFromCart($type ,(int) $id);
        if (!$removeFromCart['success']) {
            return redirect()->back()->with('err_message', $removeFromCart['message']);
        }
        return redirect()->back()->with('flash_message', $removeFromCart['message']);
    }

    public function cart(){
        return view('front.cart.shoppingCart');
    }
}
