<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/admin/profile';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    protected function credentials(Request $request)
    {
        $login = $request->input($this->username());
        
        // بررسی اینکه ورودی ایمیل، نام کاربری یا شماره موبایل است
        $field = filter_var($login, FILTER_VALIDATE_EMAIL) ? 'email' : 
                (preg_match('/^[0-9]+$/', $login) ? 'mobile' : 'username');
        
        return [
            $field => $login,
            'password' => $request->input('password'),
        ];
    }

    public function username()
    {
        return 'username'; // این نام باید با نام فیلد ورودی در فرم لاگین مطابقت داشته باشد
    }
}
