<?php

// namespace App\Http\Controllers\Auth;

// use App\Http\Controllers\Controller;
// use Illuminate\Foundation\Auth\SendsPasswordResetEmails;

// class ForgotPasswordController extends Controller
// {
//     /*
//     |--------------------------------------------------------------------------
//     | Password Reset Controller
//     |--------------------------------------------------------------------------
//     |
//     | This controller is responsible for handling password reset emails and
//     | includes a trait which assists in sending these notifications from
//     | your application to your users. Feel free to explore this trait.
//     |
//     */

//     use SendsPasswordResetEmails;
// }


// app/Http/Controllers/Auth/ForgotPasswordController.php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Notifications\SendResetCode;
// use App\Services\SmsService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Mail\Mail;
use Illuminate\Support\Facades\Hash;

class ForgotPasswordController extends Controller
{
    // نمایش فرم مرحله اول (ورود ایمیل یا تلفن)
    public function showRequestForm()
    {
        return view('auth.passwords.request');
    }

    // تولید و ارسال کد
    public function sendCode(Request $request)
    {
        $request->validate([
            'identity' => ['required', 'string'],
        ]);

       

        $identity = $request->input('identity');
        $isEmail  = filter_var($identity, FILTER_VALIDATE_EMAIL);
        $user = $isEmail
            ? User::where('email', $identity)->first()
            : User::where('phone', $identity)->first();

        if (! $user) {
            return back()->withErrors(['identity' => 'کاربری با این مشخصات یافت نشد.']);
        }

        

        // تولید کد ۶ رقمی
        $code = random_int(100000, 999999);

        // درج یا آپدیت در جدول password_resets
        DB::table('password_reset_tokens')->updateOrInsert(
            $isEmail ? ['email' => $identity] : ['phone' => $identity],
            [
                'email'      => $isEmail ? $identity : null,
                'mobile'      => $isEmail ? null : $identity,
                'token'      => Hash::make($code),
                'created_at' => Carbon::now(),
            ]
        );
        

     

        // ارسال کد
        if ($isEmail) {
            // $user->notify(new SendResetCode($code));
             
        } else {
            // $sms->send($identity, "کد بازیابی رمز شما: {$code}");
        }

        

        // به مرحله دوم می‌رویم
        return response()->json([
            'status' => 'code_sent',
            'code' => $code
        ]);
    }

    // اعتبارسنجی کد و نمایش فرم تغییر رمز
    public function verifyCode(Request $request)
    {
        $request->validate([
            'identity' => ['required','string'],
            'code'     => ['required','digits:6'],
        ]);

        $identity = $request->input('identity');
        $isEmail  = filter_var($identity, FILTER_VALIDATE_EMAIL);
        $record = DB::table('password_reset_tokens')
            ->where($isEmail ? 'email' : 'mobile', $identity)
            ->first();

        if (! $record || ! Hash::check($request->code, $record->token)) {
            return back()->withErrors(['code'=>'کد نامعتبر است.']);
        }

        // منقضی شدن ۱۰ دقیقه
        if (Carbon::parse($record->created_at)->addMinutes(10)->isPast()) {
            return back()->withErrors(['code'=>'کد منقضی شده است.']);
        }

        // نگه داشتن identity در سشن برای مرحله بعد
        session(['reset_identity' => $identity]);

        return response()->json(['status'=>'verified']);
    }

    // ذخیره رمز جدید
    public function resetPassword(Request $request)
    {
        $request->validate([
            'password' => ['required','string','min:8','confirmed'],
        ]);

        $identity = session('reset_identity');
        $isEmail  = filter_var($identity, FILTER_VALIDATE_EMAIL);
        $user = $isEmail
            ? User::where('email', $identity)->firstOrFail()
            : User::where('mobile', $identity)->firstOrFail();

        $user->password = Hash::make($request->password);
        $user->save();

        // پاک کردن رکورد OTP
        DB::table('password_reset_tokens')
            ->where($isEmail ? 'email' : 'phone', $identity)
            ->delete();

        // لاگین خودکار (اختیاری)
        auth()->login($user);

        return redirect()->route('front.index')->with('status','رمز عبور با موفقیت تغییر کرد.');
    }

}

