<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\UploadRequest;
use App\Models\Upload;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Spatie\Permission\Models\Permission;

class UploadController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'آپلود فایل';
                break;
            case 'create':
                return 'افزودن  فایل';
                break;
            case 'edit':
                return 'ویرایش ندارد';
                break;
            case 'url_back':
                return route('admin.upload.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:upload_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:upload_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:upload_delete', ['only' => ['destroy']]);
    }

    public function index()
    {
        $items = Upload::orderByDesc('id')->get();
        return view('admin.setting.upload.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        return view('admin.setting.upload.create', compact('url_back'), ['title' => $this->controller_title('create')]);
    }

    public function store(UploadRequest $request)
    {
        try {
            $item = Upload::create([
                'title' => $request->title,
            ]);

            if ($request->hasFile('file')) {
                $item->file = file_store($request->file, 'assets/admin/uploads/setting/upload-file' . '/');
                $item->save();
            }
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function edit($id)
    {

    }

    public function update(Request $request, $id)
    {

    }

    public function destroy($id)
    {
        $item = Upload::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
