<?php

namespace App\Http\Controllers\Admin\Setting;

use App\Models\About;
use App\Http\Requests\Setting\AboutRequest;
use App\Http\Controllers\Controller;
use App\Models\Photo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;

use Spatie\Permission\Models\Permission;
class AboutController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'index':
                return 'درباره ما';
                break;
            case 'create':
                return 'افزودن  ندارد';
                break;
            case 'edit':
                return 'ویرایش درباره ما';
                break;
            case 'url_back':
                return route('admin.about.index');
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:about_list', ['only' => ['index','show']]);
        $this->middleware('permission:about_edit', ['only' => ['edit','update']]);
    }

    public function index()
    {
        $items=About::orderBy('id')->get();
        return view('admin.setting.about.index', compact('items'), ['title' => $this->controller_title('index')]);
    }
    public function show($id)
    {

    }
    public function create()
    {

    }
    public function store(SliderRequest $request)
    {

    }
    public function edit($id)
    {
        $url_back=$this->controller_title('url_back');
        $item=About::findOrFail($id);
        return view('admin.setting.about.edit',compact('url_back','item'), ['title' => $this->controller_title('edit')]);
    }
    public function update(AboutRequest $request,$id)
    {
        $item=About::findOrFail($id);
        try {
            About::where('id',$id)->update([
                'title' => $request->title,
                'title1' => $request->title1,
                'title2' => $request->title2,
                'text' => $request->text,
                'text1' => $request->text1,
                'text2' => $request->text2,
                'text3' => $request->text3,
            ]);

            if ($request->hasFile('photo')) {
                if($item->photo)
                {
                    if(is_file($item->photo->path))
                    {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/setting/about' , '/');
                $item->photo()->save($photo);
            }
            if ($request->hasFile('photo2')) {
                if($item->photo2)
                {
                    if(is_file($item->photo2->path))
                    {
                        File::delete($item->photo2->path);
                        delete_directory($item->photo2->path);
                    }
                    $item->photo2->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo2';
                $photo->path = file_store($request->photo2, 'assets/admin/uploads/setting/about/2/' , '/');
                $item->photo2()->save($photo);
            }
            store_lang($item,$request,['title','title1', 'title2','text','text1','text2','text3'],'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function destroy($id)
    {

    }
}
