<?php

namespace App\Http\Controllers\Admin\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use App\Http\Requests\Product\ProductEncyclopediaRequest;
use App\Models\Photo;
use App\Models\ProductEncyclopedia;
use App\Models\ProductEncyclopediaAttr;
use App\Models\Product;

class ProductEncyclopediaController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'دانشنامه';
                break;
            case 'create':
                return 'افزودن دانشنامه';
                break;
            case 'edit':
                return 'ویرایش دانشنامه';
                break;
            case 'attr_list':
                return 'لیست ویژگی های ';
                break;
            case 'url_back':
                return route('admin.product-encyclopedia.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:product_encyclopedia_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:product_encyclopedia_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:product_encyclopedia_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:product_encyclopedia_delete', ['only' => ['destroy']]);
        $this->middleware('permission:product_encyclopedia_sort', ['only' => ['sort']]);
        $this->middleware('permission:product_encyclopedia_status', ['only' => ['status']]);
        $this->middleware('permission:product_encyclopedia_attr', ['only' => ['attr_list','attr_store','attr_sort','attr_destroy']]);
    }

    public function index()
    {
        $items = ProductEncyclopedia::orderByDesc('id')->get();
        return view('admin.product.encyclopedia.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        $products = Product::orderBy('id')->get();
        return view('admin.product.encyclopedia.create', compact('url_back', 'products'), ['title' => $this->controller_title('create')]);
    }

    public function store(ProductEncyclopediaRequest $request)
    {
        try {
            $item = ProductEncyclopedia::create([
                'product_id' => json_encode($request->product_id),
                'title' => $request->title,
                'top_text' => $request->top_text,
                'slug' => $request->slug,
                'text1' => $request->text1,
                'text2' => $request->text2,
                'status' => $request->status,
            ]);
            //create chemistry
            if ($request->hasFile('chemistry')) {
                $photo = new Photo();
                $photo->type = 'chemistry';
                $photo->path = file_store($request->chemistry, 'assets/admin/uploads/product/encyclopedia/chemistry/' . '/');
                $item->chemistry()->save($photo);
            }
            //create product
            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/product/encyclopedia/photo/' . '/');
                $item->photo()->save($photo);
            }
//            added gallery photos
            if ($request->hasFile('photos')) {
                foreach ($request->photos as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/encyclopedia/gallery/', '/');
                    $item->gallery()->save($gallery);
                }
            }
//            added gallery photos
            if ($request->hasFile('photos_mobile')) {
                foreach ($request->photos_mobile as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery_mobile';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/encyclopedia/gallery/mobile/', '/');
                    $item->gallery()->save($gallery);
                }
            }
            store_lang($item, $request, ['title','top_text', 'text1', 'text2', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $products = Product::orderBy('id')->get();
        $item = ProductEncyclopedia::findOrFail($id);
        return view('admin.product.encyclopedia.edit', compact('url_back', 'item', 'products'), ['title' => $this->controller_title('edit')]);
    }

    public function update(ProductEncyclopediaRequest $request, $id)
    {
        $item = ProductEncyclopedia::findOrFail($id);
        try {
            ProductEncyclopedia::where('id', $id)->update([
                'product_id' => json_encode($request->product_id),
                'title' => $request->title,
                'top_text' => $request->top_text,
                'slug' => $request->slug,
                'text1' => $request->text1,
                'text2' => $request->text2,
                'status' => $request->status,
            ]);
            //edit product
            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/product/encyclopedia/photo/' . '/');
                $item->photo()->save($photo);
            }
            //edit chemistry
            if ($request->hasFile('chemistry')) {
                if ($item->chemistry) {
                    if (is_file($item->chemistry->path)) {
                        File::delete($item->chemistry->path);
                        delete_directory($item->chemistry->path);
                    }
                    $item->chemistry->delete();
                }
                $photo = new Photo();
                $photo->type = 'chemistry';
                $photo->path = file_store($request->chemistry, 'assets/admin/uploads/product/encyclopedia/chemistry/' . '/');
                $item->chemistry()->save($photo);
            }
//            added gallery photos
            if ($request->hasFile('photos')) {
                foreach ($request->photos as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/encyclopedia/gallery/'. '/');
                    $item->gallery()->save($gallery);
                }
            }
//            added gallery photos
            if ($request->hasFile('photos_mobile')) {
                foreach ($request->photos_mobile as $photo) {
                    $gallery = new Photo();
                    $gallery->type = 'gallery_mobile';
                    $gallery->path = file_store($photo, 'assets/admin/uploads/product/encyclopedia/gallery/mobile/', '/');
                    $item->gallery()->save($gallery);
                }
            }
            store_lang($item, $request, ['title','top_text', 'text1', 'text2', 'status'], 'edit');
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function destroy($id)
    {
        $item = ProductEncyclopedia::findOrFail($id);
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function sort($id, Request $request)
    {
        $item = ProductEncyclopedia::findOrFail($id);
        if((int)$request->sort < 0)
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، عدد صحیح وارد کنید');
        try {
            $item->sort = (int)$request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت سورت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function status($id,$type, Request $request)
    {
        $item = ProductEncyclopedia::findOrFail($id);
        try {
            $item->status_home = $type;
            $item->update();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت تغیر وضعیت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای تغیر وضعیت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function attr_list($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = ProductEncyclopedia::findOrFail($id);
        $items = ProductEncyclopediaAttr::where('item_id',$id)->orderBy('sort')->get();
        return view('admin.product.encyclopedia.attr.index', compact('url_back', 'items','id'), ['title' => $this->controller_title('attr_list') . $item->title]);
    }
    public function attr_store($id,Request $request)
    {
        $item = ProductEncyclopedia::findOrFail($id);
        $this->validate($request, [
            'title' => 'required|max:200',
            'value' => 'required|max:200',
        ]);
        try {
            $item = ProductEncyclopediaAttr::create([
                'item_id' => $id,
                'title' => $request->title,
                'value' => $request->value,
                'status' => $request->status,
            ]);

            store_lang($item, $request, ['title', 'value', 'status'], 'create');

            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
    public function attr_destroy($id)
    {
        $item = ProductEncyclopediaAttr::findOrFail($id);
        try {
            $item->delete();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function attr_sort($id, Request $request)
    {
        $item = ProductEncyclopediaAttr::findOrFail($id);
        if((int)$request->sort < 0)
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، عدد صحیح وارد کنید');
        try {
            $item->sort = (int)$request->sort;
            $item->update();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت سورت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
