<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\TeamRequest;
use Illuminate\Http\Request;
use App\Models\Team;
use App\Models\Photo;
use Illuminate\Support\Facades\File;

class TeamController extends Controller
{

    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'تیم ما';
                break;
            case 'create':
                return 'افزودن تیم';
                break;
            case 'edit':
                return 'ویرایش تیم';
                break;
            case 'url_back':
                return route('admin.team.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:team_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:team_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:team_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:team_delete', ['only' => ['destroy']]);
        $this->middleware('permission:team_sort', ['only' => ['sort']]);
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $items = Team::orderByDesc('id')->get();
        return view('admin.other.team.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.other.team.create', ['title' => $this->controller_title('create')]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(TeamRequest $request)
    {
        try {
            $item = Team::create([
                'name' => $request->name,
                'text' => $request->text,
                'dis' => $request->dis,
                'status' => $request->status,
            ]);

            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/Teams' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item, $request, ['name','text','dis', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Team $Team)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Team $team)
    {
        return view('admin.other.team.edit', compact('team'), ['title' => $this->controller_title('edit')]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(TeamRequest $request, Team $Team)
    {
        try {
            $Team->update([
                'name' => $request->name,
                'text' => $request->text,
                'dis' => $request->dis,
                'status' => $request->status,
            ]);

            if ($request->hasFile('photo')) {
                if ($Team->photo) {
                    if (is_file($Team->photo->path)) {
                        File::delete($Team->photo->path);
                        delete_directory($Team->photo->path);
                    }
                    $Team->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/Teams' . '/');
                $Team->photo()->save($photo);
            }

            store_lang($Team, $request, ['name','text','dis', 'status', 'slug'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Team $Team)
    {
        try {
            $Team->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function sort($id,Request $request)
    {
        $item=Team::findOrFail($id);
        try {
            $item->sort=$request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت سورت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
