<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\PartnerRequest;
use App\Models\Partner;
use App\Models\Photo;
use Illuminate\Support\Facades\File;

class PartnerController extends Controller
{

    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'همکاران ما';
                break;
            case 'create':
                return 'افزودن همکاران';
                break;
            case 'edit':
                return 'ویرایش همکاران';
                break;
            case 'url_back':
                return route('admin.partner.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:partner_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:partner_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:partner_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:partner_delete', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $items = Partner::orderByDesc('id')->get();
        return view('admin.other.partner.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.other.partner.create', ['title' => $this->controller_title('create')]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(PartnerRequest $request)
    {
        try {
            $item = Partner::create([
                'title' => $request->title,
                'link' => $request->link,
                'status' => $request->status,
            ]);

            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/partners' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item, $request, ['title', 'status'], 'create');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Certificate $certificate)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Partner $partner)
    {
        return view('admin.other.partner.edit', compact('partner'), ['title' => $this->controller_title('edit')]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(PartnerRequest $request, Partner $partner)
    {
        try {
            $partner->update([
                'title' => $request->title,
                'link' => $request->link,
                'status' => $request->status,
            ]);

            if ($request->hasFile('photo')) {
                if ($partner->photo) {
                    if (is_file($partner->photo->path)) {
                        File::delete($partner->photo->path);
                        delete_directory($partner->photo->path);
                    }
                    $partner->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/partners' . '/');
                $partner->photo()->save($photo);
            }

            store_lang($partner, $request, ['title', 'status'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Partner $partner)
    {
        try {
            $partner->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
