<?php

namespace App\Http\Controllers\Admin\Other;

use App\Http\Controllers\Controller;
use App\Http\Requests\Other\BannerRequest;
use App\Models\Banner;
use App\Models\Photo;
use Illuminate\Support\Facades\File;

class BannerController extends Controller
{

    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'بنر';
                break;
            case 'create':
                return 'افزودن بنر';
                break;
            case 'edit':
                return 'ویرایش بنر';
                break;
            case 'url_back':
                return route('admin.banner.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:banner_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:banner_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:banner_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:banner_delete', ['only' => ['destroy']]);
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $items = Banner::orderByDesc('id')->get();
        return view('admin.other.banner.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.other.banner.create', ['title' => $this->controller_title('create')]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(BannerRequest $request)
    {
        try {
            $item = Banner::create([
                'title' => $request->title,
                'link' => $request->link,
                'place' => $request->place,
                'status' => $request->status,
            ]);

            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/banners' . '/');
                $item->photo()->save($photo);
            }
            if ($request->hasFile('photo_default')) {
                $photo = new Photo();
                $photo->type = 'photo_default';
                $photo->path = file_store($request->photo_default, 'assets/admin/uploads/banners/default' . '/');
                $item->photo_default()->save($photo);
            }

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Banner $banner)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Banner $banner)
    {
        return view('admin.other.banner.edit', compact('banner'), ['title' => $this->controller_title('edit')]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(BannerRequest $request, Banner $banner)
    {
        try {
            $banner->update([
                'title' => $request->title,
                'link' => $request->link,
//                'place' => $request->place,
                'status' => $request->status,
            ]);

            if ($request->hasFile('photo')) {
                if ($banner->photo) {
                    if (is_file($banner->photo->path)) {
                        File::delete($banner->photo->path);
                        delete_directory($banner->photo->path);
                    }
                    $banner->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/banners' . '/');
                $banner->photo()->save($photo);
            }
            if ($request->hasFile('photo_default')) {
                if ($banner->photo_default) {
                    if (is_file($banner->photo_default->path)) {
                        File::delete($banner->photo_default->path);
                        delete_directory($banner->photo_default->path);
                    }
                    $banner->photo_default->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo_default';
                $photo->path = file_store($request->photo_default, 'assets/admin/uploads/banners' . '/');
                $banner->photo_default()->save($photo);
            }

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Banner $banner)
    {
        try {
            $banner->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
