<?php

namespace App\Http\Controllers\Admin\Library;

use App\Http\Controllers\Controller;
use App\Http\Requests\Library\LibraryRequest;
use App\Models\Library;
use Illuminate\Http\Request;
use App\Models\LibraryCat;
use App\Services\LibraryService;
use App\Services\TransactionService;

class LibraryController extends Controller
{
    private $lib_service;


    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'دسته محصولات';
                break;
            case 'create':
                return 'افزودن دسته';
                break;
            case 'edit':
                return 'ویرایش دسته';
                break;
            case 'url_back':
                return route('admin.manage-library.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct(LibraryService $lib_service)
    {
        $this->lib_service = $lib_service;
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $title = 'کتابخانه';
        $items = Library::latest()->get();
        return view('admin.library.library.index' , compact('title' , 'items'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $title = 'کتابخانه';
        $cats_id = LibraryCat::orderByDesc('priority')->get();
        return view('admin.library.library.create' , compact('title' , 'cats_id'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(LibraryRequest $request)
    {

        $transaction = TransactionService::run(function() use ($request){
            $this->lib_service->lib_create($request);
        });

        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $title = 'کتابخانه';
        $item = Library::findOrFail($id);
        $cats_id = LibraryCat::orderByDesc('priority')->get();
        return view('admin.library.library.edit' , compact('title','item' , 'cats_id'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(LibraryRequest $request, string $id)
    {
        $lib = Library::findOrFail($id);
        $transaction = TransactionService::run(function() use ($request , $lib) {
            $this->lib_service->lib_update($request , $lib);
        });

        if (!$transaction['result']) {
            dd($transaction['message']);
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $lib = Library::findOrFail($id);
        $transaction = TransactionService::run(function() use ($lib){
            $this->lib_service->lib_delete($lib);
        });

        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
    }
}
