<?php

namespace App\Http\Controllers\Admin\Library;

use App\Http\Controllers\Controller;
use App\Http\Requests\Library\LibraryCatRequest;
use App\Models\LibraryCat;
use App\Services\LibraryService;
use App\Services\TransactionService;
use Illuminate\Http\Request;

class LibraryCatController extends Controller
{
    private $lib_service;


    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'دسته محصولات';
                break;
            case 'create':
                return 'افزودن دسته';
                break;
            case 'edit':
                return 'ویرایش دسته';
                break;
            case 'url_back':
                return route('admin.library-categories.index');
                break;
            default:
                return '';
                break;
        }
    }


    public function __construct(LibraryService $lib_service)
    {
        $this->lib_service = $lib_service;
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $items = LibraryCat::orderByDesc('priority')->get();
        $title = 'دسته بندی کتابخانه';
        return view('admin.library.category.index' , compact('items' , 'title'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $title = 'دسته بندی کتابخانه';
        $cats = LibraryCat::all();
        return view('admin.library.category.create' , compact('title' , 'cats'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(LibraryCatRequest $request)
    {
        $transaction = TransactionService::run(function() use ($request){
            $this->lib_service->cat_store($request);
        });
        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $title = 'ویرایش دسته بندی';
        $item = LibraryCat::FindOrFail($id);
        $cats = LibraryCat::where('parent_id' , null)->where('id' , '!=' , $id)->get();
        return view('admin.library.category.edit' , compact('title' , 'item' , 'cats'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(LibraryCatRequest $request, string $id)
    {
        $cat = LibraryCat::findOrFail($id);
        $transaction = TransactionService::run(function() use ($request , $cat){
            $this->lib_service->cat_update($request , $cat);
        });
        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $cat = LibraryCat::findOrFail($id);
        $transaction = TransactionService::run(function() use ($cat){
            $this->lib_service->cat_delete($cat);
        });
        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
    }

    public function sort_cat($id , Request $request){
        $cat = LibraryCat::findOrFail($id);
        $priority = $request->sort;
        $transaction = TransactionService::run(function() use ( $cat , $priority){
            $this->lib_service->sort_cat($cat , $priority);
        });
        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
    }
}
