<?php

namespace App\Http\Controllers\Admin\Form;

use App\Models\ContactForm;
use App\Http\Controllers\Controller;
use App\Models\Comment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use settingbon\settingbon;

class AllFormController extends Controller
{
    public function controller_title($type)
    {
        switch ($type)
        {
            case 'contact':
                return 'فرم تماس با ما';
                break;
            case 'comment':
                return 'نظرات';
                break;
            default:
                return '';
                break;
        }
    }
    public function __construct()
    {
        $this->middleware('permission:form_contact_list', ['only' => ['contact']]);
        $this->middleware('permission:comment_list', ['only' => ['comment','comment_destroy']]);
    }

    public function contact()
    {
        $items=ContactForm::orderBYDesc('id')->get();
        return view('admin.form.contact', compact('items'), ['title' => $this->controller_title('contact')]);
    }

    public function comment()
    {
        $items= Comment::where('parent_id',null)->orderBYDesc('id')->get();
        return view('admin.form.comment', compact('items'), ['title' => $this->controller_title('comment')]);
    }


    public function comment_status($id)
    {
        $item=Comment::where('id',$id)->firstOrFail();
        try {
            $item->status =  !$item->status;
            $item->update();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت تغییر وضعیت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای تغییر وضعیت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function comment_destroy($id)
    {
        $item = Comment::where('id', $id)->firstOrFail();
        try {
            $item->delete();
            return redirect()->back()->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }



}
