<?php

namespace App\Http\Controllers\Admin\Financial;

use App\Http\Controllers\Controller;
use App\Http\Middleware\Financial\WithdrawRequestMiddleware;
use App\Models\WithdrawRequest;
use App\Services\FinancialService;
use App\Services\TransactionService;
use Illuminate\Http\Request;

class WithdrawRequestController extends Controller
{
    protected $f_service;
    public function __construct(FinancialService $f_service)
    {
        $this->f_service = $f_service;
        $this->middleware(WithdrawRequestMiddleware::class)->only('result');
    }


    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'درخواست های برداشت';
                break;
            case 'create':
                return 'ایجاد درخواست';
                break;
            case 'edit':
                return 'بررسی درخواست';
                break;
            case 'url_back':
                return route('admin.withdraw-requests.index');
                break;
            default:
                return '';
                break;
        }
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $title = 'درخواست های برداشت';
        $requests = WithdrawRequest::latest()->get();
        return view('admin.withdrawRequest.index' , compact('title' , 'requests'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $title = 'درخواست برداشت';
        $request = WithdrawRequest::findOrFail($id);
        return view('admin.withdrawRequest.show' , compact('request' , 'title'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function result(Request $request , $id){
        $request->validate([
            'type' => 'required',
            'transaction_code' => 'required_if:type,accept',
            'reason' => 'required_if:type,reject'
        ] , [
            'transaction_code.required_if' => 'کد تراکنش الزامی است',
            'reason.required_if' => 'علت رد الزامی است'
        ]);
        $withdraw = WithdrawRequest::findOrFail($id);
        $transaction = TransactionService::run(function() use ($request , $withdraw){
            $this->f_service->withdraw_result($request , $withdraw);
        });

        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
    }
}
