<?php

namespace App\Http\Controllers\Admin\Education;

use App\Http\Controllers\Controller;
use App\Models\Education;
use App\Services\EducationService;
use App\Services\TransactionService;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\EducationGroup;

class ManageGroupsController extends Controller
{


    
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'دسته محصولات';
                break;
            case 'create':
                return 'افزودن دسته';
                break;
            case 'edit':
                return 'ویرایش دسته';
                break;
            case 'url_back':
                return route('admin.education-categories.index');
                break;
            default:
                return '';
                break;
        }
    }

    protected $e_service;
    public function __construct(EducationService $e_service)
    {
        $this->e_service = $e_service;
    }
    public function edu_group($id){
        $title = 'گروه بندی دوره';
        $edu = Education::findOrFail($id);
        return view('admin.education.groups.groups' , compact('edu' , 'title'));
    }

    public function save_changes(Request $request){
        foreach ($request->input_group as $key => $gp) {
            $group = EducationGroup::findOrFail($key);
            if ($gp != "") {
                $group->users()->sync(array_map('intval' , explode(',' , $gp)));
            }else{
                $group->users()->sync([]);
            }
        }

        return redirect()->back()->with('flash_message', 'ویرایش انجام شد');
    }

    public function add_group(Request $request , $id){
        $request->validate([
            'gp_name' => 'required',
            'gp_date_start' => 'required',
            'gp_date_end' => 'required|after_or_equal:gp_date_start'
        ],[
            'gp_name.required' => 'نام الزامی است',
            'gp_date_start.required' => 'تاریخ الزامی است',
            'gp_date_end.required' => 'تاریخ پایان الزامی است',
            'after_or_equal' => 'تاریخ پایان نمیتواند قبل از تاریخ شروع باشد'
        ]);


        $start = Carbon::parse(my_gdate_time($request->gp_date_start));
        $end = Carbon::parse(my_gdate_time($request->gp_date_end));

        $education = Education::findOrFail($id);
        $conflict = $education->groups()->where(function ($q) use ($start, $end) {
            $q->whereBetween('start_time', [$start, $end])
              ->orWhereBetween('end_time', [$start, $end])
              ->orWhere(function ($q2) use ($start, $end) {
                  $q2->where('start_time', '<=', $start)
                     ->where('end_time', '>=', $end);
              });
        })->exists();

        if ($conflict) {
            return redirect()->back()->withInput()->with('err_message', 'زمان برگزاری با گروه دیگر تداخل دارد');
        }

        $transaction = TransactionService::run(function() use ($education , $request){
            $this->e_service->add_group($education , $request);
        });

        if (!$transaction['result']) {

            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect()->back()->with('flash_message', 'گروه افزوده شد');
    }
}
