<?php

namespace App\Http\Controllers\Admin\Education;

use App\Http\Controllers\Controller;
use App\Http\Requests\Education\EducationLessonsRequest;
use App\Models\Education;
use App\Models\Lesson;
use App\Models\Chapter;
use App\Services\EducationService;
use App\Services\TransactionService;
use Illuminate\Http\Request;

class EducationLessonsController extends Controller
{
    private $e_service;

    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'دسته محصولات';
                break;
            case 'create':
                return 'افزودن دسته';
                break;
            case 'edit':
                return 'ویرایش دسته';
                break;
            case 'url_back':
                return route('admin.manage-lessons.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct(EducationService $e_service)
    {
        $this->e_service = $e_service;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $title = 'جلسات دوره آموزشی';
        $items = Lesson::all();
        return view('admin.education.lessons.index' , compact('title' , 'items'));
    }

    public function indexChaptersLessons($id){
        $chapter = Chapter::findOrFail($id);
        $title = 'جلسات دوره آموزشی';
        $items = $chapter->lessons;
        return view('admin.education.lessons.index' , compact('title' , 'items'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $title = 'ایجاد جلسه آموزشی';
        $cats = Education::where('type' , 'online')->latest()->get();
        return view('admin.education.lessons.create' , compact('title' , 'cats'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(EducationLessonsRequest $request)
    {
        $transaction = TransactionService::run(function() use ($request){
            $this->e_service->lesson_create($request);
        });

        if (!$transaction['result']) {
            dd($transaction['message']);
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $title = 'ویرایش جلسه دوره آموزشی';
        $item = Lesson::findOrFail($id);
        $cats = Education::where('type' , 'online')->latest()->get();
        return view('admin.education.lessons.edit' , compact('item' , 'title' , 'cats'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(EducationLessonsRequest $request, string $id)
    {
        $lesson = Lesson::findOrFail($id);
        $transaction = TransactionService::run(function() use ($request , $lesson){
            $this->e_service->lesson_update($request , $lesson);
        });

        if (!$transaction['result']) {
            dd($transaction['message']);
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
