<?php

namespace App\Http\Controllers\Admin\Education;

use App\Http\Controllers\Controller;
use App\Http\Requests\Education\EducationRequest;
use App\Models\Education;
use App\Models\EducationCat;
use App\Models\User;
use App\Services\EducationService;
use App\Services\TransactionService;
use Illuminate\Http\Request;
use Carbon\Carbon;


class EducationController extends Controller
{
    private $e_service;
    public function __construct(EducationService $e_service)
    {
        $this->e_service = $e_service;
    }


    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'دسته محصولات';
                break;
            case 'create':
                return 'افزودن دسته';
                break;
            case 'edit':
                return 'ویرایش دسته';
                break;
            case 'url_back':
                return route('admin.manage-educations.index');
                break;
            default:
                return '';
                break;
        }
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $title = 'دوره های آموزشی';
        $items = Education::latest()->get();
        return view('admin.education.education.index', compact('title', 'items'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $cats_id = EducationCat::orderByDesc('priority')->get();
        $title = 'ایجاد دوره آموزشی';
        $users = User::all();
        return view('admin.education.education.create', compact('cats_id', 'title', 'users'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(EducationRequest $request)
    {
        $transaction = TransactionService::run(function () use ($request) {
            $this->e_service->education_create($request);
        });

        if (!$transaction['result']) {
            dd($transaction['message']);
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $item = Education::findOrFail($id);
        $title = 'ویرایش دسته بندی';
        $cats_id = EducationCat::latest()->get();
        $users = User::all();
        return view('admin.education.education.edit', compact('item', 'title', 'cats_id', 'users'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(EducationRequest $request, string $id)
    {
        $item = Education::findOrFail($id);
        $transaction = TransactionService::run(function () use ($request, $item) {
            $this->e_service->education_update($request, $item);
        });

        if (!$transaction['result']) {
            dd($transaction['message']);
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
