<?php

namespace App\Http\Controllers\Admin\Education;

use App\Http\Controllers\Controller;
use App\Http\Requests\Education\EducationChaptersRequest;
use App\Models\Chapter;
use App\Models\Education;
use App\Services\EducationService;
use App\Services\TransactionService;
use Illuminate\Http\Request;

class EducationChaptersController extends Controller
{
    private $e_service;


    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'دسته محصولات';
                break;
            case 'create':
                return 'افزودن دسته';
                break;
            case 'edit':
                return 'ویرایش دسته';
                break;
            case 'url_back':
                return route('admin.manage-chapters.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct(EducationService $e_service)
    {
        $this->e_service = $e_service;
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $title = 'سرفصل های آموزشی';
        $items = Chapter::all();
        return view('admin.education.chapters.index' , compact('items' , 'title'));
    }

    public function indexLessonChapters(Request $request ,$id){
        $educations = Education::findOrfail($id);
        $title = 'سرفصل های آموزشی';
        $items = $educations->chapters;

        if ($request->ajax()) {
            return response()->json(['success' => true , 'data' => $items], 200);
        }

        return view('admin.education.chapters.index' , compact('items' , 'title' ));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $title = 'ایجاد سرفصل آموزشی';
        $cats = Education::all();
        return view('admin.education.chapters.create' , compact('title' ,'cats'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(EducationChaptersRequest $request)
    {
        $transaction = TransactionService::run(function() use ($request){
            $this->e_service->chapter_create($request);
        });

        if (!$transaction['result']) {
            dd($transaction['message']);
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $item = Chapter::findOrFail($id);
        $title = 'ویرایش سرفصل آموزشی';
        $cats = Education::all();
        return view('admin.education.chapters.edit' , compact('title' , 'item' ,'cats'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(EducationChaptersRequest $request, string $id)
    {
        $chapter = Chapter::findOrFail($id);
        $transaction = TransactionService::run(function() use ($request , $chapter){
            $this->e_service->chapter_update($request , $chapter);
        });

        if (!$transaction['result']) {
            dd($transaction['message']);
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
