<?php

namespace App\Http\Controllers\Admin\Education;

use App\Http\Controllers\Controller;
use App\Http\Requests\Education\EducationCatRequest;
use App\Models\EducationCat;
use App\Services\EducationService;
use App\Services\TransactionService;
use Illuminate\Http\Request;

class EducationCatController extends Controller
{
    private $e_service;


    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'دسته محصولات';
                break;
            case 'create':
                return 'افزودن دسته';
                break;
            case 'edit':
                return 'ویرایش دسته';
                break;
            case 'url_back':
                return route('admin.education-categories.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct(EducationService $e_service)
    {
        $this->e_service = $e_service;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $items = EducationCat::orderByDesc('priority')->get();
        $title = 'مدیریت دسته بندی آموزش';
        return view('admin.education.category.index' , compact('title' ,'items'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $title = 'دسته بندی دوره های آموزشی';
        $cats = EducationCat::where('parent_id' , null)->get();
        return view('admin.education.category.create' , compact('title' , 'cats'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(EducationCatRequest $request)
    {
       $transaction = TransactionService::run(function() use ($request){
        $this->e_service->cat_store($request);
       });

       if (!$transaction['result']) {
        dd($transaction['message']);
        return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
    }
    return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $cats = EducationCat::where('parent_id' , null)->get();
        $item = EducationCat::findOrFail($id);
        $title = 'ویرایش دسته بندی آموزش';
        return view('admin.education.category.edit' , compact('cats' , 'item' , 'title'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(EducationCatRequest $request, string $id)
    {
        $cat = EducationCat::findOrFail($id);
        $transaction = TransactionService::run(function() use ($request , $cat){
            $this->e_service->cat_update($request , $cat);
        });

        if (!$transaction['result']) {
            dd($transaction['message']);
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $cat = EducationCat::findOrFail($id);
        $transaction = TransactionService::run(function() use ($cat){
            $this->e_service->cat_delete($cat);
        });

        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
    }

    public function sort_cat($id , Request $request){
        $cat = EducationCat::findOrFail($id);
        $priority = $request->sort;
        $transaction = TransactionService::run(function() use ( $cat , $priority){
            $this->e_service->sort_cat($cat , $priority);
        });
        if (!$transaction['result']) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
        return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
    }
}
