<?php

namespace App\Http\Controllers\Admin\Blog;

use App\Http\Controllers\Controller;
use App\Http\Requests\Blog\BlogRequest;
use App\Models\Blog;
use App\Models\BlogCategory;
use App\Models\Photo;
use App\Models\Tag;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class BlogController extends Controller
{
    public function controller_title($type)
    {
        switch ($type) {
            case 'index':
                return 'مقالات';
                break;
            case 'create':
                return 'افزودن مقاله';
                break;
            case 'edit':
                return 'ویرایش مقاله';
                break;
            case 'url_back':
                return route('admin.blog.index');
                break;
            default:
                return '';
                break;
        }
    }

    public function __construct()
    {
        $this->middleware('permission:blog_list', ['only' => ['index', 'show']]);
        $this->middleware('permission:blog_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:blog_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:blog_delete', ['only' => ['destroy']]);
        $this->middleware('permission:blog_sort', ['only' => ['sort']]);
    }

    public function index()
    {
        $items = Blog::orderBy('sort')->get();
        return view('admin.blog.index', compact('items'), ['title' => $this->controller_title('index')]);
    }

    public function show($id)
    {

    }

    public function create()
    {
        $url_back = $this->controller_title('url_back');
        $categories = BlogCategory::orderBy('sort')->get();
        $tags = Tag::orderBy('sort')->get();
        return view('admin.blog.create', compact('url_back','categories','tags'), ['title' => $this->controller_title('create')]);
    }

    public function store(BlogRequest $request)
    {
        try {
            $item = Blog::create([
                'title' => $request->title,
                // 'category_id' => 1,
                'category_id' => $request->category_id,
                'user_id' => auth()->user()->id,
                'short_text' => $request->short_text,
                'text' => $request->text,
                'slug' => $request->slug,
                'author' => $request->author,
                'meta_description' => $request->meta_description,
                'meta_title' => $request->meta_title,
                'status' => $request->status,
                'tags' => $request->tags,
            ]);

            if ($request->hasFile('photo')) {
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/blogs' . '/');
                $item->photo()->save($photo);
            }

            store_lang($item, $request, ['title', 'text', 'short_text', 'status', 'slug', 'author', 'meta_title', 'meta_description'], 'create');
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت افزوده شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای افزودن به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function edit($id)
    {
        $url_back = $this->controller_title('url_back');
        $item = Blog::where('id', $id)->firstOrFail();
        $categories = BlogCategory::orderBy('sort')->get();
        $tags = Tag::orderBy('sort')->get();
        return view('admin.blog.edit', compact('url_back', 'item','categories','tags'), ['title' => $this->controller_title('edit')]);
    }

    public function update(BlogRequest $request, $id)
    {
        $item = Blog::where('id', $id)->firstOrFail();
        try {
            Blog::where('id', $id)->update([
                'title' => $request->title,
                'short_text' => $request->short_text,
                'text' => $request->text,
                'slug' => $request->slug,
                'author' => $request->author,
                'meta_description' => $request->meta_description,
                'meta_title' => $request->meta_title,
                'status' => $request->status,
                'tags' => $request->tags,
            ]);

            if ($request->hasFile('photo')) {
                if ($item->photo) {
                    if (is_file($item->photo->path)) {
                        File::delete($item->photo->path);
                        delete_directory($item->photo->path);
                    }
                    $item->photo->delete();
                }
                $photo = new Photo();
                $photo->type = 'photo';
                $photo->path = file_store($request->photo, 'assets/admin/uploads/blogs' . '/');
                $item->photo()->save($photo);
            }
            store_lang($item, $request, ['title', 'text', 'short_text', 'status', 'slug', 'author', 'meta_title', 'meta_description'], 'edit');

            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت ویرایش شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای ویرایش به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function destroy($id)
    {
        $item = Blog::where('id', $id)->firstOrFail();
        try {
            $item->delete();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت حذف شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای حذف به مشکل خوردیم، مجدد تلاش کنید');
        }
    }

    public function sort($id, Request $request)
    {
        $item = Blog::where('id', $id)->firstOrFail();
        try {
            $item->sort = $request->sort;
            $item->update();
            return redirect($this->controller_title('url_back'))->with('flash_message', 'اطلاعات با موفقیت سورت شد');
        } catch (\Exception $e) {
            return redirect()->back()->withInput()->with('err_message', 'برای سورت به مشکل خوردیم، مجدد تلاش کنید');
        }
    }
}
