<?php

use App\Models\Lang;
use App\Models\LangSet;
use App\Models\SiteWord;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
if (!function_exists('isMobile')) {
    function isMobile()
    {
        return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
    }
}
if (!function_exists('createMoleculeSvg')) {
    function createMoleculeSvg($formula) {
        $svgWidth = 300; // اندازه SVG
        $svgHeight = 300; // اندازه SVG
        $centerX = $svgWidth / 2;
        $centerY = $svgHeight / 2;
        $lineLength = 40; // کاهش طول خط
        $gap = 20; // کاهش فاصله از مرکز
        $atomFontSize = 24; // تغییر اندازه فونت اتم‌ها

        // تجزیه فرمول
        preg_match_all('/([A-Z][a-z]*)(\d*)/', $formula, $matches, PREG_SET_ORDER);

        $atoms = [];
        foreach ($matches as $match) {
            $symbol = $match[1];
            $count = isset($match[2]) && $match[2] !== '' ? (int)$match[2] : 1;
            for ($i = 0; $i < $count; $i++) {
                $atoms[] = $symbol;
            }
        }

        if (count($atoms) <= 1) {
            return 'فرمول معتبر نیست یا اتم‌های کافی ندارد.';
        }

        $centerAtom = array_shift($atoms); // اتم وسط

        $numberOfBranches = count($atoms);

        // زاویه شروع: 45 درجه برای حالت ضربدری
        $startAngle = 45;
        $angleStep = 360 / $numberOfBranches;

        $svg = '<svg width="' . $svgWidth . '" height="' . $svgHeight . '" style="background: #ccc;">'; // تغییر سایز SVG

        // اتم مرکزی
        $svg .= '<text x="' . ($centerX - 10) . '" y="' . ($centerY + 10) . '" font-size="' . $atomFontSize . '" font-family="Arial" font-weight="bold">' . $centerAtom . '</text>';

        // رسم شاخه‌ها
        for ($i = 0; $i < $numberOfBranches; $i++) {
            $angle = deg2rad($startAngle + $i * $angleStep);

            // شروع خط (با فاصله gap)
            $startX = $centerX + cos($angle) * $gap;
            $startY = $centerY + sin($angle) * $gap;

            // انتهای خط
            $endX = $centerX + cos($angle) * ($gap + $lineLength);
            $endY = $centerY + sin($angle) * ($gap + $lineLength);

            // مکان نوشتن اتم متصل شده
            $atomX = $centerX + cos($angle) * ($gap + $lineLength + 20) - 10;
            $atomY = $centerY + sin($angle) * ($gap + $lineLength + 20) + 10;

            // رسم خط
            $svg .= '<line x1="' . $startX . '" y1="' . $startY . '" x2="' . $endX . '" y2="' . $endY . '" stroke="black" stroke-width="2" />';

            // رسم اتم شاخه
            $svg .= '<text x="' . $atomX . '" y="' . $atomY . '" font-size="20" font-family="Arial" font-weight="bold" fill="darkblue">' . $atoms[$i] . '</text>';
        }

        $svg .= '</svg>';

        return $svg;
    }
}
if (!function_exists('icon_svg')) {
    function icon_svg($type)
    {
        if($type=='category')
        {
            return '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-menu-button-fill" viewBox="0 0 16 16">
  <path d="M1.5 0A1.5 1.5 0 0 0 0 1.5v2A1.5 1.5 0 0 0 1.5 5h8A1.5 1.5 0 0 0 11 3.5v-2A1.5 1.5 0 0 0 9.5 0zm5.927 2.427A.25.25 0 0 1 7.604 2h.792a.25.25 0 0 1 .177.427l-.396.396a.25.25 0 0 1-.354 0zM0 8a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm1 3v2a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2zm14-1V8a1 1 0 0 0-1-1H2a1 1 0 0 0-1 1v2zM2 8.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5m0 4a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5"/>
</svg>';
        }
    }
}
if (!function_exists('photo_alt')) {
    function photo_alt($item, $real, $alt)
    {
        if ($item->$real && !blank($item->$real->alt)) {
            $alt = $item->$real->alt;
        }
        return $alt;
    }
}
if (!function_exists('captcha')) {
    function captcha()
    {
        header('Content-type: image/jpeg');
        $image_name = rand(100, 120);
        $string = rand(1000, 9999);
        session(['captcha_code' => $string]);
        $font_size = 30;
        $img_width = 150;
        $img_height = 40;

        $image = imagecreate($img_width, $img_height); // create background image with dimensions
        imagecolorallocate($image, 255, 255, 255); // set background color
        $text_color = imagecolorallocate($image, 0, 0, 0); // set captcha text color
        imagettftext($image, $font_size, 0, 15, 30, $text_color, 'Vazir-Bold.ttf', $string);
        $image_name = 'captcha' . '/' . $image_name . '.png';
        imagejpeg($image, $image_name);
        imagedestroy($image);
        return $image_name;
//            return 44;
    }
}
if (!function_exists('captcha2')) {
    function captcha2()
    {
        header('Content-type: image/jpeg');
        $image_name = rand(120, 140);
        $string = rand(1000, 9999);
        session(['captcha_code2' => $string]);
        $font_size = 30;
        $img_width = 150;
        $img_height = 40;

        $image = imagecreate($img_width, $img_height); // create background image with dimensions
        imagecolorallocate($image, 255, 255, 255); // set background color
        $text_color = imagecolorallocate($image, 0, 0, 0); // set captcha text color
        imagettftext($image, $font_size, 0, 15, 30, $text_color, 'Vazir-Bold.ttf', $string);
        $image_name = 'captcha' . '/' . $image_name . '.png';
        imagejpeg($image, $image_name);
        imagedestroy($image);
        return $image_name;
//            return 44;
    }
}

if (!function_exists('optimize_img')) {
    function optimize_img($path)
    {
        $WEBSERVICE = 'http://api.resmush.it/ws.php?img=';
        $optimized_png_arr = json_decode(file_get_contents($WEBSERVICE . urlencode(url($path))));

        if (isset($optimized_png_arr->dest)) {
            $optimized_png_url = $optimized_png_arr->dest;

            $fp = fopen($path, 'w+');

            $ch = curl_init($optimized_png_url);
            curl_setopt($ch, CURLOPT_FILE, $fp);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_TIMEOUT, 1000);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla5.0');
            curl_exec($ch);

            curl_close($ch);
            fclose($fp);
        }
    }
}

if (!function_exists('ip_address')) {
    function ip_address()
    {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if (getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if (getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if (getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if (getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if (getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }
}

if (!function_exists('isFile')) {
    function isFile($url)
    {

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($code == 200) {
            $status = true;
        } else {
            $status = false;
        }
        curl_close($ch);
        return $status;
    }
}


if (!function_exists('default_lang')) {
    function default_lang()
    {
        return LangSet::where('status', 'default')->firstOrFail()->lang;
    }
}
if (!function_exists('dir_set')) {
    function dir_set()
    {
        return LangSet::where('lang', app()->getLocale())->firstOrFail()->align;
    }
}
if (!function_exists('font_farsi')) {
    function font_farsi()
    {
        return LangSet::where('lang', app()->getLocale())->firstOrFail()->farsi_font;
    }
}

if (!function_exists('tab_langs')) {
    function tab_langs()
    {
        return LangSet::get();
    }
}
if (!function_exists('menu_langs')) {
    function menu_langs()
    {
        return LangSet::whereIN('status', ['active', 'default'])->where('lang', '!=', app()->getLocale())->orderBy('sort')->get();
    }
}
if (!function_exists('menu_langs_all')) {
    function menu_langs_all()
    {
        return LangSet::whereIN('status', ['active', 'default'])->orderBy('sort')->get();
    }
}
if (!function_exists('site_lang')) {
    function site_lang()
    {
        return LangSet::where('lang', app()->getLocale())->first();
    }
}
if (!function_exists('lang')) {
    function lang()
    {
        return app()->getLocale();
    }
}
if (!function_exists('store_lang')) {
    function store_lang($item, $request, $cols, $type, $end = null)
    {
        $langs = LangSet::all();

        if ($type == 'edit') {
            foreach ($item->langs as $l_del) {
                $l_del->delete();
            }
        }
        foreach ($langs as $lang) {
            foreach ($cols as $col) {
                if ($end == 'not_request') {

                    $crm_lang_en = CrmLang::where('value', $item->$col)->first();

                    if ($crm_lang_en) {
                        $crm_lang = CrmLang::where('parent_id', $crm_lang_en->id)->where('lang', $lang->lang)->first();

                        if ($crm_lang) {
                            $new_l = new Lang();
                            $new_l->col_name = $col;
                            $new_l->lang = $lang->lang;
                            $new_l->text = $crm_lang->value;
                            $item->langs()->save($new_l);
                        }
                    }
                } else {
                    $col_lang = $col . '_' . $lang->lang;
                    if (!blank($request->$col_lang)) {
                        $new_l = new Lang();
                        $new_l->col_name = $col;
                        $new_l->lang = $lang->lang;
                        $new_l->text = $request->$col_lang;
                        $item->langs()->save($new_l);
                    }
                }
            }
        }
    }
}
if (!function_exists('read_lang')) {
    function read_lang($item, $col_name, $lang = null)
    {
        $lang = $lang == null ? lang() : $lang;
        $lang_def = LangSet::where('lang', $lang)->first();

        if ($lang_def->status == 'default') {
            $text = $item->$col_name;
        } else {
            $lang_item = $item->langs->where('lang', $lang_def->lang)->where('col_name', $col_name)->first();
            if ($lang_item)
                $text = $lang_item->text;
            else
                $text = null;
        }

        return $text;
    }
}
if (!function_exists('read_lang_word')) {
    function read_lang_word($slug, $lang = null)
    {
        $item = SiteWord::where('slug', $slug)->first();

        if (!$item) {
            return null;
        }
        $col_name = 'word';
        $lang = $lang == null ? app()->getLocale() : $lang;
        $lang_def = LangSet::where('lang', $lang)->first();

        if ($lang_def->lang == 'fa') {
            $text = $item->$col_name;
        } else {
            $text = null;
            if ($item->langs && count($item->langs)) {
                $lang_item = $item->langs->where('lang', $lang_def->lang)->where('col_name', $col_name)->first();

                if ($lang_item)
                    $text = $lang_item->text;
            }
        }
        return $text;
    }
}
if (!function_exists('status_check')) {
    function status_check($item, $lang = null)
    {
        $status = false;
        $lang = $lang ?? lang();
        $lang_def = LangSet::where('lang', $lang)->first();

        if ($lang_def->status == 'default')
            $status = $item->status == 'active' ? true : false;
        else {
            $lang_item = $item->langs->where('lang', $lang_def->lang)->where('col_name', 'status')->first();
            if ($lang_item)
                $status = $lang_item->text == 'active' ? true : false;
        }

        return $status;
    }
}
if (!function_exists('status_check_all')) {
    function status_check_all($items, $lang = null)
    {
        $lang = $lang ?? app()->getLocale();
        $items = $items->filter(function ($item) use ($lang) {
            if (status_check($item, $lang)) {
                return $item;
            }
        });

        return $items;
    }
}
if (!function_exists('num_to_en')) {
    function num_to_en($data)
    {
        $persian = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹', '٤', '٥', '٦'];
        $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '4', '5', '6'];
        $output = str_replace($persian, $english, $data);
        return $output;
    }
}
if (!function_exists('type_file')) {
    function type_file($item)
    {
        $type = explode('.', $item);
        $end = end($type);
        return $end;
    }
}
if (!function_exists('explode_last')) {
    function explode_last($item, $joda)
    {
        $type = explode($joda, $item);
        $end = end($type);
        return $end;
    }
}
if (!function_exists('phone_check')) {
    function phone_check($item)
    {
        $number = '';
        $number .= substr($item, 0, 3);
        $number .= '-';
        $number .= substr($item, 3);
        return $number;
    }
}
if (!function_exists('status')) {
    function status($item)
    {
        switch ($item) {
            case 'active':
            {
                return '<span class="badge badge-success">فعال</span>';
                break;
            }
            case 'pending':
            {
                return '<span class="badge badge-warning">درحال بررسی</span>';
                break;
            }
            case 'blocked':
            {
                return '<span class="badge badge-danger">مسدود</span>';
                break;
            }
            case 'cancel':
            {
                return '<span class="badge badge-danger">کنسل</span>';
                break;
            }
            case 'inactive':
            {
                return '<span class="badge badge-danger">غیرفعال</span>';
                break;
            }
        }
    }
}
if (!function_exists('file_type')) {
    function file_type($file)
    {
        // تشخیص MIME Type فایل
        $mimeType = $file->getMimeType();
        $type=null;
        if (str_starts_with($mimeType, 'image/')) {
            $type= 'image';
        } elseif (str_starts_with($mimeType, 'video/')) {
            $type= 'video';
        } elseif (str_starts_with($mimeType, 'text/')) {
            $type= 'text';
        } else {
            $type= '';
        }

        return $type;
    }
}
if (!function_exists('file_store')) {
    function file_store($u_file, $u_path)
    {
        $file = $u_file;
        $originalName = $u_file->getClientOriginalName();
        $destinationPath = $u_path . my_jdate(date('Y/m/d'), 'Y-m-d') . '/' . time();
        $file->move($destinationPath, $originalName);
        return $destinationPath . '/' . $originalName;
    }
}

if (!function_exists('delete_directory')) {
    function delete_directory($path)
    {
        $path_array = explode('/', $path);
        $file_name = '/' . end($path_array);
        $directory_name = str_replace($file_name, '', $path);
        File::deleteDirectory($directory_name);

        $pre_path_array = explode('/', $directory_name);
        $pre_file_name = '/' . end($pre_path_array);
        $pre_directory_name = str_replace($pre_file_name, '', $directory_name);
        $arr1 = scandir($pre_directory_name);
        unset($arr1[0], $arr1[1]);

        if (count($arr1) == 0)
            File::deleteDirectory($pre_directory_name);
    }
}

if (!function_exists('my_gdate_time')) {
    function my_gdate_time($data)
    {
        require_once('jdf.php');
    

        $parts = explode(' ', $data);
        $datePart = $parts[0] ?? null;
        $timePart = $parts[1] ?? '00:00:00';

        $datePart = str_replace('-', '/', $datePart);
        $dateArray = explode('/', $datePart);
    
        if (count($dateArray) === 3) {
            $gDate = jalali_to_gregorian($dateArray[0], $dateArray[1], $dateArray[2], '-');
            return $gDate . ' ' . $timePart; 
        }
    
        return false;
    }
}

if (!function_exists('my_gdate')) {
    function my_gdate($data)
    {
        $data = str_replace('-', '/', $data);
        $data = explode('/', $data);
        if (count($data) > 2) {
            require_once('jdf.php');
            $date = jalali_to_gregorian($data[0], $data[1], $data[2], '/');
            return $date;
        }
        return false;
    }
}
if (!function_exists('my_jdate')) {
    function my_jdate($date, $type)
    {
        $timestamp = (strtotime($date));
        require_once('jdf.php');
        $jalali_date = jdate($type, $timestamp);
        return $jalali_date;
    }
}

if (!function_exists('array_pluck')) {
    function array_pluck($items, $value, $title, $defult = null)
    {
        $r = [];
        if ($defult != null) {
            $r = [$defult[0] => $defult[1]];
        }

        $r += Arr::pluck($items, $value, $title);
        return $r;

    }
}
if (!function_exists('array_pluck2')) {
    function array_pluck2($items, $value, $value2, $title, $defult = null)
    {
        $r = [];
        if ($defult != null) {
            $r = [$defult[0] => $defult[1]];
        }

        $r += Arr::pluck($items, $value, $title);
        return $r;

    }
}
